#include <OneWire.h>  // OneWire 헤더파일 호출
int DS18S20_Pin = 2; //센서 입력핀
OneWire ds(DS18S20_Pin);//센서 입력핀 설정
void setup(void) {  // 초기화
  Serial.begin(9600);// 시리얼 통신설정
}
/*온도값을 시리얼 모니터를 통해서 보여준다.*/  
void loop(void) {  // 무한루프
  float temperature = getTemp();//getTemp함수로 읽오온 값을 temperature에 저장한다.
  Serial.println(temperature);//시리얼 모니터로 온도값 출력
  delay(500); //0.5초 지연
}  
float getTemp(){ //온도값을 읽어오는 함수
  
  byte data[12];
  byte addr[8];
  
  if ( !ds.search(addr)) {
      //no more sensors on chain, reset search
      ds.reset_search();
      return -1000;
  }
  
  if ( OneWire::crc8( addr, 7) != addr[7]) {
      Serial.println("CRC is not valid!");
      return -1000;
  }
  
  if ( addr[0] != 0x10 && addr[0] != 0x28) {
      Serial.print("Device is not recognized");
      return -1000;
  }
  
  ds.reset();
  ds.select(addr);
  ds.write(0x44,1); // start conversion, with parasite power on at the end
  
  byte present = ds.reset();
  ds.select(addr);    
  ds.write(0xBE); // Read Scratchpad
  
    
  for (int i = 0; i < 9; i++) { // we need 9 bytes
    data[i] = ds.read();
  }
    
  ds.reset_search();
    
  byte MSB = data[1];
  byte LSB = data[0];
  
  float tempRead = ((MSB << 8) | LSB); //using two's compliment
  float TemperatureSum = tempRead / 16;
    
  return TemperatureSum;
    
}
